package com.izenpe.zain.cliente.smime;

import org.apache.axis.encoding.Base64;

import com.izenpe.zain.client.ZainConfig;
import com.izenpe.zain.cliente.util.Constantes;
import com.izenpe.zain.cliente.util.Propiedades;
import com.izenpe.zain.cliente.util.ZainUtil;
import com.safelayer.trustedx.client.smartwrapper.Constants;
import com.safelayer.trustedx.client.smartwrapper.SmartVerifyRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartVerifyResponse;

public class VerificacionFirmaSMIME {
	public static void main(String[] args) {
		try {
			// Asignacin de la configuracin de forma programtica
			ZainConfig.setCurrent(Propiedades.ZAIN_CONFIG);

			/*
			 * Se crea la peticin a travs de la URL definida en ZAIN_ENDPOINT.
			 */
			SmartVerifyRequest smartVerifyReq = new SmartVerifyRequest(Propiedades.ZAIN_ENDPOINT);

			// Se establece el perfil SMIME en la peticin de Verificacin de
			// firma.
			smartVerifyReq.setProfile(Constants.Profile.SMIME);

			/*
			 * Se establece el idioma de la peticin en espaol. 2
			 * posibilidades: 1. Espaol: 'es' 2. Ingls: 'en'
			 */
			smartVerifyReq.setLanguage("es");

			/*
			 * Se solicita en la peticin de Verificacin que se aadan a la
			 * respuesta los valores de los certificados.
			 */
			smartVerifyReq.setAddCertificateValues(Constants.AddValues.SIMPLE);

			/*
			 * Se solicita en la peticin de Verificacin que se aadan a la
			 * respuesta la informacin de revocacin de los certificados.
			 */
			smartVerifyReq.setAddRevocationValues(Constants.AddValues.SIMPLE);

			/*
			 * Se solicita en la peticin de Verificacin que se aadan los
			 * valores del Sello de Tiempo.
			 */
			smartVerifyReq.setAddTimeStampValues(Constants.AddValues.SIMPLE);
			
			smartVerifyReq.setAddSignatureForm(true);

			// Datos a verificar.
			smartVerifyReq.setSignatureMime(Base64.encode(ZainUtil.readBinaryFile("data/output/smime-v2.txt")));

			// Envo de la peticin.
			SmartVerifyResponse smartVerifyResp = smartVerifyReq.send();

			// Se comprueba la validez de la respuesta de Verificacin de firma
			// SMIME.
			if (Constantes.RMAJOR_SUCCESS.equals((smartVerifyResp.getResultMajor()))
					&& Constantes.RMINOR_SUCCESS.equals(smartVerifyResp.getResultMinor())) {
				String signMime = smartVerifyResp.getDocumentMime();
				String destFilename = "data/output/mimeVerificado-izenpe.txt";
				ZainUtil.writeBinaryFile(destFilename, signMime.getBytes());
				System.out.println("La firma ha sido verificada con xito.");
			} else {
				System.out.println("La firma tiene errores: " + smartVerifyResp.getResultMessage());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}